/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.BitMap;
import oracle.ias.cache.Response;

class ResponseQ {
    static final int ALLOC_SIZE = 16;
    Response[] rList;
    Response freelist;

    ResponseQ() {
        this.growResponseList(16);
    }

    synchronized Response getRespSlot(boolean bl) {
        if (this.freelist == null) {
            this.growResponseList(this.rList.length + 16);
        }
        Response response = this.freelist;
        this.freelist = response.next;
        response.singleReply = bl;
        return response;
    }

    synchronized void freeRespSlot(int n) {
        Response response = this.rList[n];
        response.free();
        response.next = this.freelist;
        this.freelist = response;
    }

    boolean record(long l, int n, int n2, byte[] byArray, String string, String string2) {
        int n3 = (int)(l >> 32);
        int n4 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        Response response = this.rList[n3];
        return response.recordResponse(n, n2, n4, byArray, string, string2);
    }

    boolean awaitOwnership(long l, int n, boolean bl, int n2) {
        int n3 = (int)(l >> 32);
        int n4 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        Response response = this.rList[n3];
        return response.awaitOwnership(n, bl, n4, n2);
    }

    void saveSearch(long l, Object object) {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        Response response = this.rList[n];
        response.saveSearch(n2, object);
    }

    void saveSearchList(long l, int n, Object object, int n2) {
        int n3 = (int)(l >> 32);
        int n4 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        Response response = this.rList[n3];
        response.saveSearchList(n4, n, object, n2);
    }

    void setParticipants(long l, BitMap bitMap, int n) {
        int n2 = (int)(l >> 32);
        int n3 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        Response response = this.rList[n2];
        response.setParticipants(n3, bitMap, n);
    }

    synchronized void resetParticipants(BitMap bitMap, int n) {
        for (int i = 0; i < this.rList.length; ++i) {
            Response response = this.rList[i];
            if (response == null || response.participants == null) continue;
            response.resetPmap(bitMap, n);
        }
    }

    private synchronized void growResponseList(int n) {
        int n2;
        Response[] responseArray = new Response[n];
        int n3 = 0;
        if (this.rList != null) {
            n2 = this.rList.length;
            for (n3 = 0; n3 < this.rList.length; ++n3) {
                responseArray[n3] = this.rList[n3];
            }
        } else {
            n2 = 0;
        }
        responseArray[n3] = new Response(n3);
        responseArray[n3].id = n3;
        ++n3;
        while (n3 < n) {
            responseArray[n3] = new Response(n3);
            responseArray[n3].id = n3;
            responseArray[n3 - 1].next = responseArray[n3];
            ++n3;
        }
        this.freelist = responseArray[n2];
        this.rList = responseArray;
    }
}

